//Exp 7.5 Program Title:To Implement Image segmentation discontinuties using edge detection Laplacian operator
////environment: Scilab 5.5.2
//Toolbox: Image Processing Design 8.3.1-1
//Toolbox: SIVP 0.5.3.2
//Tested on OS: Windows 7 Professional, 64 bit
//Reference books names : 1)Digital Image Processing book author :
// Rafael C.Gonzalez and Richard E.Woods,
//2)Digital Image Processing book author :S.Sudhir,
//3)Digital Image Processing book author :Dhanajay Theckedath
clc //to clear command window.
clear all //to disable previously defined variables.
xdel(winsid());///clear all the previous figures plots
SIVP_PATH = getSIVPpath(); //to locate a directory in which SIVP toolbox is installed
im1=imread(SIVP_PATH + 'images/rose.bmp');//read  color image from directory
im2=rgb2gray(im1);
//Laplacian mask
M1=[0 ,-1,0;-1,4,-1;0,-1,0];  
im3=sum_of_product(im2,M1);//convolution
im5=uint8(im3);
figure(1);ShowColorImage(im1,'Original Color image');title('original color image','color','red','fontsize',6');//IPD tool box
figure(2);ShowImage(im2,' Grayscale image');title('Grayscale image','color','red','fontsize',6');//IPD tool box
figure(3);ShowImage(im3,' Laplacian mask Edges');title('Laplacian mask Edges','color','red','fontsize',6');//IPD tool box

